/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230425
********************************************************************************/

/********************************INCLUDES*************************************/
#include "Periph.h"
#include <stdio.h>


/****************************************************************
//Funtion : GPIo_Init
//Input   : None
//Output  : None
//Note    :IO初始化
****************************************************************/
void GPIO_INIT(void)
{
	PAOD = 0X00;
	PBOD = 0X00;//关闭开漏

	PAPU = 0XFF;
	PBPU = 0XFF;//关闭上拉

	PAPD = 0XFF;
	PBPD = 0XFF;//关闭下拉

	TRISA=0X00;
	TRISB=0X00;//设为输出模式

	PORTA=0X00;
	PORTB=0X00;//设为低电平
}

/****************************************************************************
// * Funtion : Flash Erase
// * Intput : FLash_addr
// * Output : None
// * Note	: Falsh 擦除
*****************************************************************************/
void FLASH_Erase(unsigned int addr)
{
    GIE = 0;            //FLASH的操作过程中必须关闭中断
	IAPTRIG   = 0xad;
	IAPTRIG   = 0x18;
	IAPTRIG   = 0xf8;//enter iap_mode

	IAPADDRH  = (unsigned char)(addr>>8);
	IAPADDRL  = (unsigned char)(addr&0xff);//擦除地址

	ER = 1;//页擦除操作
	IAPTRIG   = 0X00;//exit iap_mode
    //FLASH的操作过程中必须关闭中断，如有需求可在操作完成后使能中断
    //GIE = 1;           //打开总中断使能位，若应用程序有中断使能需求，请去掉注释
}

/******************************************************************************
// Funtion : Falsh Write
// InPut   : addr: Flash写地址    pbuf: 数据（16bit）
// Output  : None
// Note	   : Falsh 写入
*******************************************************************************/
void FLASH_Write(unsigned int addr,unsigned int pbuf)
{
    GIE = 0;            //FLASH的操作过程中必须关闭中断

	IAPTRIG    = 0xad;
	IAPTRIG    = 0x18;
	IAPTRIG    = 0xf8;//enter iap_mode

	IAPADDRH = (unsigned char)(addr>>8);
	IAPADDRL = (unsigned char)(addr&0xff);//写地址
	IAPDATH  = (unsigned char)(pbuf>>8);
	IAPDATL  = (unsigned char)(pbuf&0xff);//写数据

	PG = 1;//写操作
	IAPTRIG    = 0x00;//exit iap_mode

    //FLASH的操作过程中必须关闭中断，如有需求可在操作完成后使能中断
    //GIE = 1;          //打开总中断使能位，若应用程序有中断使能需求，请去掉注释
}
/*******************************************************************************
* Description    : 读取Buf数据
* Input          : None
* Return         : None.
* Note           : 1、按页读取（每页128字节数据）
				   2、2种读取方式：数组、指针方式，任意一种都可以
*******************************************************************************/
void Falsh_Read_Array(void)
{
    unsigned char a;
	//通过数组访问获取Flash相关地址的数据
	printf("\r\n", &Buf[0]);
    for(a = 0;a < 128; a++)
	{
		if((a%16) == 0)printf("\r\n  ");

		printf("%02X,",Buf[a]);
	}
	printf("\r\n");
}

void Falsh_Read_Pointer(void)
{
	unsigned char a;
	unsigned char  *pRead = (unsigned char *)Buf;
	//通过指针获取Flash相关地址的数据
	printf("\r\n", pRead);
    for(a = 0;a < 128; a++)
	{
		if((a%16) == 0)
		{
			printf("\r\n  ");
		}
		printf("%02X,",*pRead);
		pRead++;
	}
	printf("\r\n");
}

